#ifdef _VERSION_CHECK_
	#ifndef MSET

		#ifndef _NOT_INSTANCED_
			
			#version 120
			#extension EXT_gpu_shader4 : enable          

		#endif
		
	#endif
#endif

#ifdef SKINNING

	uniform mat3 	boneMatrices[100];
				
	//	uniform samplerBuffer 	boneMatrices;
	
	attribute vec4  weights;
	attribute vec4  matrixIndices;

#endif

#ifndef _NOT_INSTANCED_
	uniform samplerBuffer 	WorldPoses;//[64];
#endif

varying vec3	eye0,
				eye1,
				eye2;

varying vec2 			texcoord,
						alphacoord;

attribute vec3 			normal,
						tangent,
						binormal; 

vec4 					outNormal,
						outTangent,
						outBinormal; 
uniform vec4			coordMod;
uniform vec2	NF;
	
vec2 ComputeFrame(float dt, vec2 nf)
{
	vec2 ofs=vec2(1.0,1.0)/nf;
	float frame=floor(dt*nf.x*nf.y);
	float row=floor(frame/nf.x);
	float col=floor(frame-nf.x*row);
	
	return vec2(ofs.x*col, 1.0-(ofs.y*row)-ofs.y);
}

void main()
{
	vec4 normal4      	= vec4( normal.xyz, 0.0 );
	vec4 binormal4      = vec4( binormal.xyz, 0.0 );
	vec4 tangent4   = vec4(cross(binormal4.xyz,normal4.xyz),0.0);
	binormal4.xyz*=binormal.w;
  
#ifdef SKINNING

	vec4 index  		= matrixIndices;
	vec4 weight 		= weights;
	vec4 position   	= vec4( 0.0, 0.0, 0.0, 0.0 );
	vec4 tempNormal  	= vec4( 0.0, 0.0, 0.0, 0.0 );
	vec4 tempTangent  	= vec4( 0.0, 0.0, 0.0, 0.0 );
	vec4 tempBinormal  	= vec4( 0.0, 0.0, 0.0, 0.0 );
	
	mat4 TM=mat4(	0.0,0.0,0.0,0.0,
					0.0,0.0,0.0,0.0,
					0.0,0.0,0.0,0.0,
					0.0,0.0,0.0,1.0);

	int j;
  	for( int i = 0; i < 4; i++ )
 	{
 	    // Apply influence of bone i
		
				j=int(index[i]);
				TM[0].xyz=boneMatrices[j][0];
				TM[1].xyz=boneMatrices[j][1];
				TM[2].xyz=cross(TM[0].xyz,TM[1].xyz);
				TM[3].xyz=boneMatrices[j][2];
				
				
				position = position + (TM * gl_Vertex) *weight[i];
			
			
		//TM=boneMatrices[int(index[i])];
  	    //position = position + (TM * gl_Vertex) *weight[i];
	
		// Transform normals by bone i
		TM[3]=vec4(0,0,0,1);
  	    tempNormal = tempNormal + (TM * normal4)*weight[i];
		tempBinormal = tempBinormal + (TM * binormal4)*weight[i];
		tempTangent = tempTangent + (TM * tangent4)*weight[i];
	}
	gl_Position = gl_ModelViewProjectionMatrix * position;

	normal4=tempNormal;
	tangent4=tempTangent;
	binormal4=tempBinormal;
	
	texcoord = gl_MultiTexCoord0.st;
		
	outNormal=gl_ModelViewMatrix*normal4;
	outTangent=gl_ModelViewMatrix*tangent4;
	outBinormal=gl_ModelViewMatrix*binormal4; 

	normalize(outNormal);
	normalize(outTangent);
	normalize(outBinormal);

	eye0=vec3(outTangent.x,outBinormal.x,outNormal.x);
	eye1=vec3(outTangent.y,outBinormal.y,outNormal.y);
	eye2=vec3(outTangent.z,outBinormal.z,outNormal.z);
	
#else

	#ifndef _NOT_INSTANCED_
	
		mat4 MTX;
		int index=gl_InstanceID*4;
		MTX[0]=texelFetchBuffer(WorldPoses,index);
		MTX[1]=texelFetchBuffer(WorldPoses,index+1);
		MTX[2]=texelFetchBuffer(WorldPoses,index+2);
		MTX[3]=texelFetchBuffer(WorldPoses,index+3);
						
		gl_Position = (gl_ModelViewProjectionMatrix*MTX)*gl_Vertex; //ftransform();
		texcoord = (gl_MultiTexCoord0.st*coordMod.xy) + coordMod.zw;	
		alphacoord	= clamp(gl_MultiTexCoord0.st,0.0,1.0);
				
		MTX=gl_ModelViewMatrix*MTX;
		outNormal=MTX*normal4;
		outTangent=MTX*tangent4;
		outBinormal=MTX*binormal4; 
		
	#else
	
		gl_Position = ftransform();
		texcoord = (gl_MultiTexCoord0.st*coordMod.xy) + coordMod.zw;	
		alphacoord	= clamp(gl_MultiTexCoord0.st,0.0,1.0);
					
		outNormal=gl_ModelViewMatrix*normal4;
		outTangent=gl_ModelViewMatrix*tangent4;
		outBinormal=gl_ModelViewMatrix*binormal4; 

	#endif
	
	normalize(outNormal);
	normalize(outTangent);
	normalize(outBinormal);

	eye0=vec3(outTangent.x,outBinormal.x,outNormal.x);
	eye1=vec3(outTangent.y,outBinormal.y,outNormal.y);
	eye2=vec3(outTangent.z,outBinormal.z,outNormal.z);
				
}